﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.Runtime.Serialization.Formatters.Soap

' 在此示例中，对象将被序列化为一个文件并从文件反序列化。
' 如果使用 Soap 格式化程序，则文件称为 SoapFile.xml。
' 如果使用 Binary 格式化程序，则文件称为 BinaryFile.dat。

Public Class Form1

    ' 这些变量是在 Form_Load 事件中初始化的。
    Private soapFile As String = "SoapFile.xml"
    Private binaryFile As String = "BinaryFile.dat"
    Private customFile As String = "CustomFile.xml"
    Private soapPath As String
    Private binaryPath As String
    Private customPath As String

#Region "加载"
    Private Sub frmMain_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load, MyBase.Load
        ' 使用 System.Io 命名空间中的 Path 类
        ' 获取系统临时路径
        Dim tempPath As String = My.Computer.FileSystem.SpecialDirectories.Temp

        soapPath = tempPath & soapFile
        binaryPath = tempPath & binaryFile
        customPath = tempPath & customFile

        StatusStrip1.Text = "All files will be written to " & tempPath & "."
    End Sub
#End Region

#Region "SOAP"
    ' 此例程创建 SerializableClass 的新实例，然后
    ' 用 SOAP 格式化程序将其序列化。
    Private Sub cmdStandardSerializationSoap_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles cmdStandardSerializationSoap.Click

        ' 创建要进行序列化的对象。
        Dim instance As New SerializableClass(CInt(txtX.Text), CInt(txtY.Text), CInt(txtZ.Text))

        ' 获取进行文件写入操作的 FileStream。
        Dim fs As New FileStream(soapPath, FileMode.OpenOrCreate)

        ' 获取 SOAP 格式化程序实例。
        Dim sf As New SoapFormatter()

        ' 序列化实例。
        sf.Serialize(fs, instance)

        ' 关闭文件并释放资源。
        fs.Close()

        ' 现在可进行反序列化。
        cmdStandardDeserializationSoap.Enabled = True
        cmdViewClass1.Enabled = True
    End Sub

    ' 此例程从文件反序列化一个对象，
    ' 并将其分配给一个 SerializableClass 引用。
    Private Sub cmdStandardDeserializationSoap_Click(ByVal sender As System.Object, _
         ByVal e As System.EventArgs) Handles cmdStandardDeserializationSoap.Click

        ' 声明引用，该引用指向将被反序列化的对象。
        Dim instance As SerializableClass

        ' 获取进行文件读取操作的 FileStream。
        Dim fs As New FileStream(soapPath, FileMode.Open)

        ' 获取 SOAP 格式化程序实例。
        Dim sf As New SoapFormatter()

        ' 从文件反序列化，创建 SerializableClass 的一个实例。
        ' 必须将经过反序列化的对象强制转换为适当的类型。
        instance = CType(sf.Deserialize(fs), SerializableClass)

        ' 关闭文件并释放资源。
        fs.Close()

        ' 将经过反序列化的字段值加入文本框。
        txtXAfter.Text = CStr(instance.PublicVariable)
        txtYAfter.Text = CStr(instance.PublicProperty)
        txtZAfter.Text = CStr(instance.NonSerializedVariable)

        ' 反序列化之后重置按钮。
        cmdStandardDeserializationSoap.Enabled = False
        cmdViewClass1.Enabled = False
    End Sub
#End Region

#Region "二进制"
    ' 此例程创建 SerializableClass 的一个新实例，然后
    ' 使用 Binary 格式化程序将其序列化为一个文件。
    Private Sub cmdStandardSerializationBinary_Click(ByVal sender As System.Object, _
         ByVal e As System.EventArgs) Handles cmdStandardSerializationBinary.Click

        ' 创建要进行序列化的对象。
        Dim instance As New SerializableClass(CInt(txtX.Text), CInt(txtY.Text), CInt(txtZ.Text))

        ' 获取进行文件写入操作的 FileStream。
        Dim fs As New FileStream(binaryPath, FileMode.OpenOrCreate)

        '获取 Binary 序列化程序实例
        Dim bf As New BinaryFormatter()

        ' 将实例序列化为文件。
        bf.Serialize(fs, instance)

        ' 关闭文件并释放资源。
        fs.Close()

        ' 现在可进行反序列化。
        cmdStandardDeserializationBinary.Enabled = True
    End Sub

    ' 此例程从文件反序列化一个对象，
    ' 并将其分配给一个 SerializableClass 引用。
    Private Sub cmdStandardDeserializationBinary_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles cmdStandardDeserializationBinary.Click

        ' 声明引用，该引用指向将被反序列化的对象。
        Dim instance As SerializableClass

        ' 获取进行文件读取操作的 FileStream。
        Dim fs As New FileStream(binaryPath, FileMode.Open)

        ' 获取一个 Binary 序列化程序实例。
        Dim bf As New BinaryFormatter()

        ' 从文件反序列化一个实例。
        ' 必须将经过反序列化的对象强制转换为适当的类型。
        instance = CType(bf.Deserialize(fs), SerializableClass)

        ' 关闭文件并释放资源。
        fs.Close()

        ' 将经过反序列化的字段值加入文本框。
        txtXAfter.Text = CStr(instance.PublicVariable)
        txtYAfter.Text = CStr(instance.PublicProperty)
        txtZAfter.Text = CStr(instance.NonSerializedVariable)

        ' 反序列化之后重置按钮。
        cmdStandardDeserializationBinary.Enabled = False
    End Sub
#End Region

#Region "自定义"
    ' 此例程创建 CustomSerializableClass 的一个新实例，
    ' 然后利用 SOAP 格式化程序将其序列化为一个文件。 
    ' 即使 CustomSerializableClass 具有自定义序列化，
    ' 客户端代码仍与标准序列化的客户端代码相同。
    ' 不同之处在于类代码，而非客户端代码。
    Private Sub cmdCustomSerialization_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles cmdCustomSerialization.Click

        ' 创建要进行序列化的对象。
        Dim instance As New CustomSerializableClass(CInt(txtX.Text), CInt(txtY.Text), CInt(txtZ.Text))

        ' 获取进行文件写入操作的 FileStream。
        Dim fs As New FileStream(customPath, FileMode.OpenOrCreate)

        ' 获取 SOAP 格式化程序实例。
        Dim sf As New SoapFormatter()

        ' 序列化实例。
        sf.Serialize(fs, instance)

        ' 关闭文件并释放资源。
        fs.Close()

        ' 现在可进行反序列化。
        cmdCustomDeserialization.Enabled = True
        cmdViewClass2.Enabled = True
    End Sub

    ' 此例程从文件反序列化一个对象，
    ' 并将其分配给一个 CustomSerializableClass 引用。即使
    ' CustomSerializableClass 具有自定义序列化，客户端代码仍与
    ' 标准序列化的客户端代码相同。不同之处在于类代码，
    ' 而非客户端代码。
    Private Sub cmdCustomDeserialization_Click(ByVal sender As System.Object, _
        ByVal e As System.EventArgs) Handles cmdCustomDeserialization.Click

        ' 声明引用，该引用指向将被反序列化的对象
        Dim instance As CustomSerializableClass

        ' 获取进行文件读取操作的 FileStream。
        Dim fs As New FileStream(customPath, FileMode.Open)

        ' 获取 SOAP 格式化程序实例。
        Dim sf As New SoapFormatter()

        ' 反序列化并创建实例。
        ' 必须将经过反序列化的对象强制转换为适当的类型。
        instance = CType(sf.Deserialize(fs), CustomSerializableClass)

        ' 关闭文件并释放资源。
        fs.Close()

        ' 将经过反序列化的字段值加入文本框。
        txtXAfter.Text = CStr(instance.PublicVariable)
        txtYAfter.Text = CStr(instance.PublicProperty)
        txtZAfter.Text = CStr(instance.NonSerializedVariable)

        ' 反序列化之后重置按钮。
        cmdCustomDeserialization.Enabled = False
        cmdViewClass2.Enabled = False
    End Sub
#End Region

#Region "视图和验证"
    ' 将文件内容转储到文本框中。此例程将文件内容快速
    ' 复制到只读文本框中。它使用户检查
    ' SerializableClass 的已序列化对象的状态。
    Private Sub cmdViewClass1_Click(ByVal sender As System.Object, _
      ByVal e As System.EventArgs) Handles cmdViewClass1.Click

        Dim fs As New FileStream(soapPath, FileMode.Open)
        Dim sr As New StreamReader(fs)
        txtView.Text = sr.ReadToEnd()
        sr.Close()
        fs.Close()
    End Sub

    ' 将文件内容转储到文本框中。此例程将文件内容快速
    ' 复制到只读文本框中。它仅允许用户检查
    ' CustomSerializableClass 的已序列化对象的状态。
    Private Sub cmdViewClass2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdViewClass2.Click

        Dim fs As New FileStream(customPath, FileMode.Open)
        Dim sr As New StreamReader(fs)
        txtView.Text = sr.ReadToEnd()
        sr.Close()
        fs.Close()
    End Sub

    Private Function IsValidInt32(ByVal data As String) As Boolean
        ' 此为 IsNumeric 的替换，只对 Int32 数据有效。
        Try
            Dim i As Integer = System.Convert.ToInt32(data)
            Return True
        Catch exp As Exception
            Return False
        End Try
    End Function

    Private Sub ValidatingTextIsInt32(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles txtZ.Validating, txtY.Validating, txtX.Validating
        ' 确保输入的值可转换为 Int32（整数）
        Dim textBox As MaskedTextBox = CType(sender, MaskedTextBox)

        If Not IsValidInt32(textBox.Text) Then
            Dim strMsg As String
            strMsg = String.Format("The value you entered {0} is not a valid 32-bit integer. Value will be changed to zero.", textBox.Text)
            MsgBox(strMsg, MsgBoxStyle.Exclamation, "Validation Warning")
            textBox.Text = "0"
        End If
    End Sub
#End Region


    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
